# Readme

The i-net PDFC NUnit API is a wrapper for the .NET programming language that uses an actual i-net PDFC server to carry out the file comparison as a NUnit test. 

## System Requirements

The NUnit API is able to run on any OS with .NET runtime installed. There is no limit to a 32 bit or 64 bit architecture.

## Visual Studio

If you want to test this API with Visual Studio or Rider then:

  * Create a new project, for example a nunit test project
  * Add a reference to the library PDFCNUnit.dll
  * Add a sample *.cs file to the project
  * Build the project and run the tests.

In the 'Documentation and Samples' folder is already a sample nunit project. 

## Usage

The PDFCNUnit.dll contains the PdfcAssert class that has the following methods.

There are multiple AssertPdfEquals and AssertPdfcNotEquals methods that gets two documents and compare them on the server.
The AssertPdfEquals methods will throw an AssertionException, if the two documents have differences and the AssertPdfcNotEquals methode, if the documents have no differences.

There are several methods to set up the server to use.

```
// the URL to the i-net PDFC server
PdfcAssert.SetServicePath("<url to the server like 'http://localhost:9900'>");
            
// the user to login to the server
PdfcAssert.SetCredentials("<user>", "<password>");

// specify the PDFC profile to be used
PdfcAssert.SetPdfcConfiguration("Text only");

// the default log level is SourceLevels.Warning
// if you search for problems then you can enable the logging
PdfcAssert.SetLogLevel(SourceLevels.Verbose);
```

